//var internalTooltip = { bitmap:"", width:0, height:0, description:"" };

function Interior(n, gameObject, stretchMode, scrollTo) {
	this.name = n;
	this.game = gameObject;
	this.image = null; // background image
	this.bitmap = null; // interior background Bitmap
	this.dialogue = null; // Dialogue object inside this interior
	this.container = null; // each interior has separate container
	this.activeElements = []; // clickable elements like arrows, people, tools etc.
	this.internalTooltips = []; // array of tooltips in this interior
	this.htmlEnabled = false; // if html is enabled - data is downloaded in AjaxInfoDialog basing on current interior hash
	this.htmlLoaded = false;
	this.stretch = typeof stretchMode !== 'undefined' ? stretchMode : "vertical"; // vertical horizontal uniform
	this.scrollpos = typeof scrollTo !== 'undefined' ? scrollTo : "left"; // left center right
}

Interior.prototype.init = function(image) {
	this.image = image;
	this.bitmap = new createjs.Bitmap(image);

	if (this.bitmap != null) {
		this.container = new createjs.Container();

		var targetWidth = window.innerWidth; //this.game.canvas.width;
		var s1 = targetWidth / this.image.width;
		var targetHeight = window.innerHeight; //this.game.canvas.height;
		var s2 = targetHeight / this.image.height;

		var hstretch = this.isHorizontalStretch();
		var s = (hstretch) ? s1 : s2;

		var w = image.width;
		var h = image.height;

		// if the image is smaller than screen (like laptop interiors)
		// fill the background with neutral color - better than white
		var shape = new createjs.Shape();
		shape.graphics.beginFill("#787878").drawRect(0, 0, 4000, 3000);
		this.container.addChild(shape);

		this.container.addChild(this.bitmap);
		this.container.x = 0;
		this.container.y = 0;

		if (!hstretch) {
			this.bitmap.y = 0;
		} else // vertically center image
		{
			if (h * s < targetHeight)
				this.bitmap.y = (targetHeight - (h * s)) / 2;
		}

		this.container.alpha = 1;
		this.container.scaleX = 1;
		this.container.scaleY = 1;

		var container = this.container;
		var c = container;
		var inter = this;

		//		var canvas = document.getElementById("mainCanvas");
		this.bitmap.addEventListener("mousedown", function(evt) {
			var canvasWidth = window.innerWidth; //.game.canvas.width;
			var canvasHeight = window.innerHeight; //window.game.canvas.height;
			var s1 = canvasWidth / inter.image.width;
			var s2 = canvasHeight / inter.image.height;
			var offset = {
				x: c.x - evt.stageX,
				y: c.y - evt.stageY
			};
			evt.addEventListener("mousemove", function(e) {
				if (inter.isHorizontalStretch()) ///hstretch) // horizontal stretch = vertical scrolling
				{
					s = s1;
					if (-(e.stageY + offset.y) >= 0 && -(e.stageY + offset.y) <= (h * s - canvasHeight)) //canvas.height))
						c.y = e.stageY + offset.y;
				} else // vertical stretch = horizontal scrolling
				{
					s = s2;
					if (-(e.stageX + offset.x) >= 0 && -(e.stageX + offset.x) <= (w * s - canvasWidth)) //(w*s-canvas.width))
						c.x = e.stageX + offset.x;
				}
			});
		});
	}
}

Interior.prototype.isHorizontalStretch = function() {
	if (this.stretch == "vertical") {
		return false;
	} else if (this.stretch == "horizontal") {
		return true;
	} else // "uniform" and spelling errors
	{
		var targetWidth = window.innerWidth; //this.game.canvas.width;
		var s1 = targetWidth / this.image.width;
		var targetHeight = window.innerHeight; //this.game.canvas.height;
		var s2 = targetHeight / this.image.height;
		if (s1 > s2)
			return true;
		else
			return false;
	}
}

Interior.prototype.enableDialogue = function(x, y, direction) {
	var dir = typeof direction !== 'undefined' ? direction : "left"; // left or right
	this.dialogue = new Dialogue(this, x, y, dir);
	return this.dialogue;
}

Interior.prototype.getContainer = function() {
	if (this.bitmap != null)
		return this.container;
	else
		return null;
}

Interior.prototype.addActiveElement = function(sprite, resname, x, y, a, target, targetAnimation, description, blink) {
	var rn = typeof resname !== 'undefined' ? resname : "";
	var ta = typeof targetAnimation !== 'undefined' ? targetAnimation : false;
	var ds = typeof description !== 'undefined' ? description : "";
	var bl = typeof blink !== 'undefined' ? blink : false;

	var s = sprite;
	if (s != null) {
		var spriteBitmap = new createjs.BitmapAnimation(s);
		spriteBitmap.gotoAndPlay("blank");
		spriteBitmap.name = rn;
		spriteBitmap.x = x;
		spriteBitmap.y = y;

		if (a == true) {
			var tweenBlink;
			if (bl) {
				tweenBlink = createjs.Tween.get(spriteBitmap, {
					loop: true
				}, true);
				tweenBlink.to({
					alpha: 1
				}, 300);
				tweenBlink.to({
					alpha: 0
				}, 300);
				tweenBlink.to({
					alpha: 1
				}, 300);
			}

			if (ds.length > 1) {
				this.internalTooltips.push({
					bitmap: spriteBitmap,
					width: s._frames[0].rect.width,
					height: s._frames[0].rect.height,
					description: ds
				});
			}

			var INTERIOR = this;
			var active = this.activeElements;

			var container = this.container;
			var b = spriteBitmap;
			spriteBitmap.removeAllEventListeners();
			if (ds.length > 1) {
				var hideAll = false;
				spriteBitmap.addEventListener("mouseover", function() {
					if (hideAll)
						INTERIOR.showTooltip(spriteBitmap, s._frames[0].rect.width, s._frames[0].rect.height, ds);
					else
						hideAll = true;
				});
				spriteBitmap.addEventListener("mouseout", function() {
					if (hideAll) $('.interiorTooltip').each(function() {
						var tooltip = $(this);
						if ($('#' + tooltip.attr('aria-describedby')).length)
							tooltip.tooltip('close');
					});
				});
			}
			spriteBitmap.addEventListener("mouseover", function() {
				if (window.isInteriorAllowed(target)) {
					if (spriteBitmap.currentAnimation == "blank") {
						spriteBitmap.cursor = "pointer";
						spriteBitmap.alpha = 0.3;
					} else {
						spriteBitmap.cursor = "default";
						spriteBitmap.alpha = 1;
					}
				}
			});
			spriteBitmap.addEventListener("mouseout", function() {
				if (window.isInteriorAllowed(target)) {
					spriteBitmap.cursor = "default";
					spriteBitmap.alpha = 1;
				}
			});
			spriteBitmap.addEventListener("click", function() {
				if (!$(".ui-dialog-content").is(':visible') && (INTERIOR.htmlEnabled === false || INTERIOR.htmlLoaded)) {
					if (window.isInteriorAllowed(target)) {
						$(document).trigger('activeElementClicked.przedsiebiorca', {
							interior: INTERIOR,
							target: target
						});
						if (ta) {
							switch (target) {
								case "intUPr1":
								case "intUPr2":
								case "intZr1":
								case "intZr2":
									// :: Karteczki
									// hide others
									for (var key in active) {
										if (!key.match(/anim$/) && key != "strzalka") {
											// if()
											active[key].y = 1090;
										} else {}
									}
									// bring up this bitmap animation
									var spriteBitmap2 = active[target];
									var tween = createjs.Tween.get(spriteBitmap2);
									tween.to({
										x: 1360,
										y: 450
									}, 1000); //573
									break;
								case "internet":
									createjs.Tween.removeTweens(spriteBitmap);
									spriteBitmap.cursor = "default";
									spriteBitmap.alpha = 1;
									spriteBitmap.onAnimationEnd = function() {
										if (spriteBitmap.currentAnimation == "opening") {
											var tween = createjs.Tween.get(container).to({
												x: -(b.x - 50) * 5,
												y: -b.y * 5,
												scaleX: 5,
												scaleY: 5,
												alpha: 1
											}, 1000).call(function() {
												spriteBitmap.gotoAndPlay("blank");
												window.location.hash = "#" + target;
											});
										}
									}
									spriteBitmap.gotoAndPlay("opening");
									break;
							}
						} else {
							var tween = createjs.Tween.get(container).to({
								x: -(b.x - 50) * 5,
								y: -b.y * 5,
								scaleX: 5,
								scaleY: 5,
								alpha: 0
							}, 1000).call(function() {
								window.location.hash = "#" + target;
							});
						}
					}
				}
			});
		}

		if (target == "back") {
			this.activeElements[target] = spriteBitmap;
			this.container.addChild(spriteBitmap);
			this.container.setChildIndex(spriteBitmap, 0);
		} else if (rn == "strzalka") {
			this.activeElements[rn] = spriteBitmap;
			this.container.addChild(spriteBitmap);
			spriteBitmap.parent.addChild(spriteBitmap);
		} else {
			//this.activeElements.push(spriteBitmap);
			this.activeElements[target + (ta ? "anim" : "")] = spriteBitmap;
			this.container.addChild(spriteBitmap);
			spriteBitmap.parent.addChild(spriteBitmap);
		}
	}
}

Interior.prototype.activateHTML = function() {
	this.htmlEnabled = true;
}

Interior.prototype.loadHTML = function() {
	var GameObject = this.game;
	if ( /*!window.DEBUG_MODE &&*/ !window.isInteriorAllowed(window.game.currentInterior)) return;
	this.htmlLoaded = false;

	//pass additional data to interior
	var data = {
		hash: window.game.currentInterior
	};
	if (this.data) //from interior data property
	{
		for (var i in this.data)
			data[i] = this.data[i];
	}
	if (this.getDataCallback) {
		var additionalData = this.getDataCallback(); //from data callback function
		for (var i in additionalData)
			data[i] = additionalData[i];
	}

	var INTERIOR = this;

	$.post(window.links.studentAjaxInteriorHTML, data)
		.done(function(data) {
			var interiorHTMLElement = $('<div></div>');
			interiorHTMLElement.attr('class', 'interiorHTMLElement');
			interiorHTMLElement.appendTo('#canvasHolder');
			interiorHTMLElement.html(data);
			GameObject.refreshScene();
			if (INTERIOR.dialogue)
				INTERIOR.dialogue.enable();
		})
		.fail(function() {
			window.location.hash = '#city';
		})
		.always(function() {
			INTERIOR.htmlLoaded = true;
		});
}

Interior.prototype.getActionElement = function(id) {
	return id;
}

Interior.prototype.enableAdditionalElements = function() {
	$('.interiorHTMLElement').remove();
	$("#dialogue").hide();

	if (this.htmlEnabled)
		this.loadHTML();
	else if (this.dialogue)
		this.dialogue.enable();
}

Interior.prototype.showTooltip = function(bitmap, width, height, description) {
	if (!bitmap) return false;

	var ds = typeof description !== 'undefined' ? description : "";
	var tooltipObj = $('<div class="gameTooltip sticker interiorTooltip" title=""></div>');
	tooltipObj.appendTo($('#canvasHolder'));

	var container = this.container;

	var x = bitmap.x;
	var y = bitmap.y;
	var w = width * container.scaleX;
	var h = height * container.scaleY;

	$(document).on('activeElementClicked.przedsiebiorca', function() {
		if ($('#' + tooltipObj.attr('aria-describedby')).length)
			tooltipObj.tooltip('close');
	});

	tooltipObj.tooltip({
		disabled: true,
		position: {
			using: function() {
				$(this).attr("canvasY", y - $(this).outerHeight(true) - 25);
				$(this).attr("canvasX", x - ($(this).outerWidth(true) - width) / 2);
				$(this).addClass("sticker");
			}
		},
		content: ds + '<div class="tooltip-arrow bottom center"></div>',
		show: {
			effect: 'slideDown',
			duration: 100
		},
		hide: {
			effect: 'slideUp',
			duration: 100
		},
		close: function(event) {
			$(event.target).remove();
		}
	});

	tooltipObj.css({
		width: w + 'px',
		height: h + 'px',
		cursor: "pointer",
		zIndex: 10,
	});
	tooltipObj.tooltip("open").on('mouseout focusout mousemove mousein focusin mouseenter mouseleave hover', function(event) {
		event.stopImmediatePropagation();
	});

	tooltipObj.click(function() {
		bitmap.dispatchEvent("click");
	});

	var tname = tooltipObj.attr('aria-describedby');

	var child = $("#" + tname);

	if (child.length) {
		child.css('text-align', 'center');
		child.css('top', '-500px');
		child.css('left', '-500px');
	}

	adjustDialoguePosition();
}

Interior.prototype.openTooltips = function() {
	$('.interiorTooltip').remove();
	for (i = 0; i < this.internalTooltips.length; i++) {
		var ct = this.internalTooltips[i];
		this.showTooltip(ct.bitmap, ct.width, ct.height, ct.description);
	}
}

Interior.prototype.scrollToPos = function() {
	var d = this.scrollpos;
	var i = this.image;
	var canv = this.game.canvas;
	var cont = this.container;
	var s = this.game.getScaleInterior();

	var w, h;
	if (canv != null && cont != null) {
		w = (i.width * s) - canv.width;
		h = (i.height * s) - canv.height;
	}

	if (d == "left") {
		cont.x = 0;
	} else if (d == "center") {
		cont.x = -(w / 2);
	} else if (d == "right") {
		cont.x = -w;
	} else // "left" on spelling errors
	{
		cont.x = 0;
	}
}
